/* This demo program is copyrighted by John Hilton and is 
   licensed for free use under the GNU Public License. 
   See copying.txt for details.
*/

#include "ports.h"
#include "portbits.h"

#define INTERRUPT __attribute__((interrupt))

#define SET_STACK __asm__ __volatile__(" lds #0x02ff ")

void 		  __premain ();
void 		  start(void);
void INTERRUPT    main_rti(void);
void INTERRUPT    main_swi(void);
void INTERRUPT    main_ill(void);
void INTERRUPT    main_int_cop(void);
void INTERRUPT    main_cmf(void);
int		  main(void);

void __premain ()
{
/* ONLY set PROTECTED registers here		*/
/* variables will be trashed after execution 	*/

/* INIT = */
TMSK2  = 0x00;
OPTION = CME+CR1+CR0;	/* enable Clock Monitor, COP about 1 sec	*/
BPROT  = 0x1F; 		/* protect all eeprom				*/
}


int main(void)
{
PACTL &= ~(RTR1+RTR0);	/* set RTI 4.1 ms = 244 Hz */
TFLG2 =RTIF;		/* clear flags 		   */
TMSK2|=RTII;		/* enable RTI		   */

                        /* check config here, throw an error if wrong !!	*/

;
__asm__ __volatile__  (" cli ");	/* start interruptions !! */
;

while(1);				/* do endless loop */

}

void INTERRUPT main_rti(void)
{
/* RTI = 244 Hz or 4.1 ms	*/
TFLG2 =RTIF;

/* do rti function						*/
}

void INTERRUPT main_swi(void)
{
SET_STACK;
/* do something */
}

void INTERRUPT main_ill(void)
{
SET_STACK;
/* do something */
}

void INTERRUPT main_int_cop(void)
{
SET_STACK;
/* do something */
}

void INTERRUPT main_cmf(void)
{
SET_STACK;
/* do something */
}

