/* This demo program is copyrighted by Tom Almy and is 
   licensed for free use under the GNU Public License. 
   See copying.txt for details.
   
Tom Almy
Internet: tom@almy.us
WWW: almy.us
anonymous ftp: aalmy@almy.us  and at anonymous@homeftp.almy.us
*/

/* Flash an LED connected to pin PT0 once per second */

#include "ioregs12.h"
#include "vectors12.h"

#define MSEC1 24000    /* Time for 1 msec in terms of clock ticks */

#define INTERRUPT __attribute__((interrupt))

void INTERRUPT    isrtc0(void);

static short count;  /* variable with millisecond count */

void __premain ()
{
/* If __premain isn't defined, a default definition that clears all the
 * bits in the CCR is used */
/* I/O registers can be initialized here, but variables may not be
 * because the default initialization occurs after __premain returns */
	TC0 = TCNT + MSEC1; /* set time for first interrupt */
	TIOS |= 1;    /* Channel 0 output compare */
	TSCR |= 0x90; /* Set TEN and TFFCA  */
	TMSK1 |= 1;   /* Set COI */
	/* DDRT |= 1;  * Enable PT0 for output */
	DDRB |= 1;    /* Enable LSB of PORTB for output (EWE modified for PortB) */
}

int main(void) {
    count = 0; /* Initialize count */
	UserTimerCh0 = (unsigned short)&isrtc0;

	/* when main returns, a function resembling __exit() shown below
	 * is called. The program never really exits! */
}

/*
void __exit(void) {
	;
__asm__ __volatile__  (" cli ");	
	;

	while(1)			
__asm__ __volatile__ (" wai ");
}
*/

void INTERRUPT isrtc0(void)
{
	count += 1;
	TC0 += MSEC1;
	if (count >= 500) {
		count = 0; /* reset count every 500 msec */
		/* PTT ^= 1; * Toggle PT0 */
		PORTB ^= 1;  /* Toggle LSB of PORTB (EWE - modified to use PortB) */
	}
}

